Include([[Data/levels/include/xeno_template.lua]])

function Level.MapGenScript()

    MapGeometry:Randomize(60000)
    MapEntities:SetParameters(LevelUtils.MapGenDefaults)
    MapEntities:GenerateLocations()

	--Capture point placement
	for i=1, 3 do
		MapEntities:PlaceCapPoint(false, -1, 2, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
	end

	for i=1, 5 do
		MapEntities:PlaceCapPoint(false, -1, 3, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
	end
	
	MapEntities:PlaceCapPoint(false, -1, 0, false, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
    --local homeBase = MapEntities:PlaceCapPoint(true, -1, 0, false, 90.0, "");
    local homePos = vect2f()
    local homePlaced = MapEntities:GetStartingPlace(homePos, 90.0)
    
    if homePlaced then
        GameWorld:AddMarines(homePos, GameWorld:GetStartingTeamSize())
        GameWorld:ResetCamera(homePos)
        --GameWorld:FocusCameraOn(homeBase)
        
        local bunker = GameWorld:CreateEntity("PropBuilding", "xenoBunker", homePos)
        
        GameWorld:RegisterRaidTarget(bunker)
        GameWorld:RegisterRespawnSource(bunker)
        
        local building = bunker:ToCHumanBuilding()
        building:CompleteBuilding()
        
        BunkerLostScript:OnBunkerCreated()
    end
    
	--Alien support structs
	MapEntities:PlaceEnemyStuctures(20.0, math.huge);
	
	--Place crates
	for i=1, 4 do
		MapEntities:PlaceBPCrate(20.0, 60.0, 15.0);
	end
	
	for i=1, 3 do
		MapEntities:PlaceAPCrate(15.0, 30.0, 6.0);
	end		
end

Level.Parameters =
{
	MarineCount 		= 5,
	MaxHiveLevel 		= 4,
	MaxSpawnRate 		= 35.0,
	StartBPMultiplier 	= 1.0,
	BPGainMultiplier    = 1.0,
	
	DefaultHiveTowerCount = 12,
}

Level.	Rules = 
{
	AutoCapture 	= true,		    --Destroying hives automatically counts as a capture
	NoPushback		= false,		--Can the player's points be captured?
	NoTowerRespawn  = true,         --Can the hive towers respawn?
	WeakenHiveOnCap = false,        --Do captures halve defensive strength?
	DisableLockdown = true,         --Turn off emergency help is player is behind
	SmartMutations	= true,			--Activate mutations using AI
}
		
Level.Mutations =
{
    CapturesPerMutation = 1,
    MaxMutations = 9,
    Default = [[inactive]],
    Active =
    {
    },
    Queue =
    {
    },
    Disabled =
    {
    },
	Randomize = true
}

Level.MarineUpgrades["RandomResearchLockCount"] = 2

------------------------------------------------------------------------------- Level Init 2
LevelInit2 = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
		ScriptMgr:DoDelayedCall(2000, function () GameWorld:ApplyNextMutation(true); end) --Random Mutation
		ScriptMgr:DoDelayedCall(5000, function () GameWorld:ApplyNextMutation(true); end) --Random Mutation
		
		self:Disable()
	end)
LevelInit2:Enable()

------------------------------------------------------------------------------- Win Achievement
LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
        SteamAchievements:SetAchievement("BEAT_TERMINUS_RAID")	
	end):Enable()
